<?php
/**
 * Loader.
 *
 * @package vip-care-purchase
 * @since 1.0.0
 */

if ( ! class_exists( 'STO_Loader' ) ) :

	/**
	 * STO_Loader
	 *
	 * @since 1.0.0
	 */
	class STO_Loader {

		/**
		 * Instance
		 *
		 * @access private
		 * @var object Class Instance.
		 * @since 1.0.0
		 */
		private static $instance;

		/**
		 * Partner data
		 *
		 * @var array<string,string>
		 * @since 1.0.0
		 * @access private
		 */
		private static $partner_data = null;

		/**
		 * Initiator
		 *
		 * @since 1.0.0
		 * @return object initialized object of class.
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 *
		 * @since 1.0.0
		 */
		public function __construct() {

			$this->define_constants();

			add_action( 'plugins_loaded', array( $this, 'load_plugin' ), 5 );
			add_action( 'plugins_loaded', [ $this, 'load_textdomain' ] );

		}

		/**
		 * Load Plugin Text Domain.
		 *
		 * @since 1.0.0
		 * @return void
		 */
		public function load_textdomain() {
			// Default languages directory.
			$lang_dir = STO_DIR . 'languages/';

			/**
			 * Filters the languages directory path to use for plugin.˜
			 *
			 * @param string $lang_dir The languages directory path.
			 */
			$lang_dir = apply_filters( 'starter_templates_onboarding_languages_directory', $lang_dir );

			// Traditional WordPress plugin locale filter.
			global $wp_version;

			$get_locale = get_locale();

			if ( $wp_version >= 4.7 ) {
				$get_locale = get_user_locale();
			}

			$locale = apply_filters( 'plugin_locale', $get_locale, 'starter-templates-onboarding' );
			$mofile = sprintf( '%1$s-%2$s.mo', 'starter-templates-onboarding', $locale );

			// Setup paths to current locale file.
			$mofile_global = WP_LANG_DIR . '/plugins/' . $mofile;
			$mofile_local  = $lang_dir . $mofile;

			if ( file_exists( $mofile_global ) ) {
				// Look for global /wp-content/languages/plugins/starter-templates-onboarding-en_US.mo.
				load_textdomain( 'starter-templates-onboarding', $mofile_global );
			} elseif ( file_exists( $mofile_local ) ) {
				// Look for local /wp-content/plugins/starter-templates-onboarding/languages/starter-templates-onboarding-en_US.mo.
				load_textdomain( 'starter-templates-onboarding', $mofile_local );
			} else {
				// Load the default language files.
				// Look into /wp-content/plugins/starter-templates-onboarding/languages/.
				load_plugin_textdomain( 'starter-templates-onboarding', false, $lang_dir );
			}
		}


		/**
		 * Define constants
		 *
		 * @since 1.0.0
		 * @return void
		 */
		public function define_constants() {

			define( 'STO_BASE', plugin_basename( STO_FILE ) );
			define( 'STO_DIR', plugin_dir_path( STO_FILE ) );
			define( 'STO_URL', plugins_url( '/', STO_FILE ) );
			define( 'STO_VER', '1.1.7' );
			// @TODO : Remove when we implement the new constant files.
			if ( ! defined( 'ZIPWP_APP' ) ) {
				define( 'ZIPWP_APP', 'https://app.zipwp.com/auth' );
			}
			if ( ! defined( 'ZIPWP_API' ) ) {
				define( 'ZIPWP_API', 'https://api.zipwp.com/api' );
			}

			define( 'STO_AUTH_URL', ZIPWP_API . '/hosting' );
		}

		/**
		 * Get the partner details
		 *
		 * @param string $key Key to get the value.
		 * @return mixed
		 * @since 1.0.7
		 */
		public static function get_partner_details( $key ) {
			if ( null === self::$partner_data ) {
				$data               = file_get_contents( STO_DIR . 'constants.json' );
				self::$partner_data = is_string( $data ) ? json_decode( $data, true ) : [];
			}

			$partner_data = self::$partner_data;

			if ( is_array( $partner_data ) && isset( $partner_data[ $key ] ) && ! empty( $partner_data[ $key ] ) ) {
				return $partner_data[ $key ];
			}
			return null;
		}

		/**
		 * Get the company contact url
		 *
		 * @return string|null
		 * @since 1.0.10
		 */
		public static function get_company_contact_url() {

			$url = self::get_partner_details( 'company_contact_url' );

			if ( empty( $url ) ) {
				$url = self::get_partner_details( 'company_url' );
			}

			return $url;
		}

		/**
		 * Load plugin
		 *
		 * @since 1.0.0
		 * @return void
		 */
		public function load_plugin() {
			$this->include_files();

		}

		/**
		 * Include files
		 *
		 * @since 1.0.0
		 * @return void
		 */
		public function include_files() {

			if ( file_exists( STO_DIR . 'inc/lib/ai-builder/ai-builder.php' ) ) {
				require_once STO_DIR . 'inc/lib/ai-builder/ai-builder.php';
			}

			if ( file_exists( STO_DIR . 'inc/lib/starter-templates-importer/starter-templates-importer.php' ) ) {
				require_once STO_DIR . 'inc/lib/starter-templates-importer/starter-templates-importer.php';
			}
			require_once STO_DIR . 'classes/class-sto-controller.php';
			if ( file_exists( STO_DIR . 'inc/admin/class-sto-admin.php' ) ) {
				require_once STO_DIR . 'inc/admin/class-sto-admin.php';
			}
		}
	}

	/**
	 * Kicking this off by calling 'get_instance()' method
	 */
	STO_Loader::get_instance();

endif;
