<?php
/**
 * UAG Utils Functions.
 *
 * @package uagb
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Get post assets object.
 *
 * @param int $post_id current step ID.
 * @since 2.0.0
 */
function uagb_get_post_assets( $post_id ) {

	if ( ! isset( uagb()->post_assets_objs[ $post_id ] ) ) {

		uagb()->post_assets_objs[ $post_id ] = new UAGB_Post_Assets( $post_id );
	}

	return uagb()->post_assets_objs[ $post_id ];
}


/**
 * Get Spectra Font Awesome Polyfiller.
 *
 * @since 2.0.0
 */
function get_spectra_font_awesome_polyfiller() {

	$font_awesome_5_polyfiller = array(
		'ad'                                  => 'rectangle-ad',
		'rectangle-ad'                        => 'rectangle-ad',
		'adjust'                              => 'circle-half-stroke',
		'circle-half-stroke'                  => 'circle-half-stroke',
		'air-freshener'                       => 'spray-can-sparkles',
		'spray-can-sparkles'                  => 'spray-can-sparkles',
		'alien-monster'                       => 'alien-8bit',
		'alien-8bit'                          => 'alien-8bit',
		'allergies'                           => 'hand-dots',
		'hand-dots'                           => 'hand-dots',
		'ambulance'                           => 'truck-medical',
		'truck-medical'                       => 'truck-medical',
		'american-sign-language-interpreting' => 'hands-asl-interpreting',
		'hands-asl-interpreting'              => 'hands-asl-interpreting',
		'analytics'                           => 'chart-mixed',
		'chart-mixed'                         => 'chart-mixed',
		'angle-double-down'                   => 'angles-down',
		'angles-down'                         => 'angles-down',
		'angle-double-left'                   => 'angles-left',
		'angles-left'                         => 'angles-left',
		'angle-double-right'                  => 'angles-right',
		'angles-right'                        => 'angles-right',
		'angle-double-up'                     => 'angles-up',
		'angles-up'                           => 'angles-up',
		'angry'                               => 'face-angry',
		'face-angry'                          => 'face-angry',
		'apple-alt'                           => 'apple-whole',
		'apple-whole'                         => 'apple-whole',
		'apple-crate'                         => 'crate-apple',
		'crate-apple'                         => 'crate-apple',
		'archive'                             => 'box-archive',
		'box-archive'                         => 'box-archive',
		'arrow-alt-circle-down'               => 'circle-down',
		'circle-down'                         => 'circle-down',
		'arrow-alt-circle-left'               => 'circle-left',
		'circle-left'                         => 'circle-left',
		'arrow-alt-circle-right'              => 'circle-right',
		'circle-right'                        => 'circle-right',
		'arrow-alt-circle-up'                 => 'circle-up',
		'circle-up'                           => 'circle-up',
		'arrow-alt-down'                      => 'down',
		'down'                                => 'down',
		'arrow-alt-from-bottom'               => 'up-from-line',
		'up-from-line'                        => 'up-from-line',
		'arrow-alt-from-left'                 => 'right-from-line',
		'right-from-line'                     => 'right-from-line',
		'arrow-alt-from-right'                => 'left-from-line',
		'left-from-line'                      => 'left-from-line',
		'arrow-alt-from-top'                  => 'down-from-line',
		'down-from-line'                      => 'down-from-line',
		'arrow-alt-left'                      => 'left',
		'left'                                => 'left',
		'arrow-alt-right'                     => 'right',
		'right'                               => 'right',
		'arrow-alt-square-down'               => 'square-down',
		'square-down'                         => 'square-down',
		'arrow-alt-square-left'               => 'square-left',
		'square-left'                         => 'square-left',
		'arrow-alt-square-right'              => 'square-right',
		'square-right'                        => 'square-right',
		'arrow-alt-square-up'                 => 'square-up',
		'square-up'                           => 'square-up',
		'arrow-alt-to-bottom'                 => 'down-to-line',
		'down-to-line'                        => 'down-to-line',
		'arrow-alt-to-left'                   => 'left-to-line',
		'left-to-line'                        => 'left-to-line',
		'arrow-alt-to-right'                  => 'right-to-line',
		'right-to-line'                       => 'right-to-line',
		'arrow-alt-to-top'                    => 'up-to-line',
		'up-to-line'                          => 'up-to-line',
		'arrow-alt-up'                        => 'up',
		'up'                                  => 'up',
		'arrow-circle-down'                   => 'circle-arrow-down',
		'circle-arrow-down'                   => 'circle-arrow-down',
		'arrow-circle-left'                   => 'circle-arrow-left',
		'circle-arrow-left'                   => 'circle-arrow-left',
		'arrow-circle-right'                  => 'circle-arrow-right',
		'circle-arrow-right'                  => 'circle-arrow-right',
		'arrow-circle-up'                     => 'circle-arrow-up',
		'circle-arrow-up'                     => 'circle-arrow-up',
		'arrow-from-bottom'                   => 'arrow-up-from-line',
		'arrow-up-from-line'                  => 'arrow-up-from-line',
		'arrow-from-left'                     => 'arrow-right-from-line',
		'arrow-right-from-line'               => 'arrow-right-from-line',
		'arrow-from-right'                    => 'arrow-left-from-line',
		'arrow-left-from-line'                => 'arrow-left-from-line',
		'arrow-from-top'                      => 'arrow-down-from-line',
		'arrow-down-from-line'                => 'arrow-down-from-line',
		'arrow-square-down'                   => 'square-arrow-down',
		'square-arrow-down'                   => 'square-arrow-down',
		'arrow-square-left'                   => 'square-arrow-left',
		'square-arrow-left'                   => 'square-arrow-left',
		'arrow-square-right'                  => 'square-arrow-right',
		'square-arrow-right'                  => 'square-arrow-right',
		'arrow-square-up'                     => 'square-arrow-up',
		'square-arrow-up'                     => 'square-arrow-up',
		'arrow-to-bottom'                     => 'arrow-down-to-line',
		'arrow-down-to-line'                  => 'arrow-down-to-line',
		'arrow-to-left'                       => 'arrow-left-to-line',
		'arrow-left-to-line'                  => 'arrow-left-to-line',
		'arrow-to-right'                      => 'arrow-right-to-line',
		'arrow-right-to-line'                 => 'arrow-right-to-line',
		'arrow-to-top'                        => 'arrow-up-to-line',
		'arrow-up-to-line'                    => 'arrow-up-to-line',
		'arrows'                              => 'arrows-up-down-left-right',
		'arrows-up-down-left-right'           => 'arrows-up-down-left-right',
		'arrows-alt'                          => 'up-down-left-right',
		'up-down-left-right'                  => 'up-down-left-right',
		'arrows-alt-h'                        => 'left-right',
		'left-right'                          => 'left-right',
		'arrows-alt-v'                        => 'up-down',
		'up-down'                             => 'up-down',
		'arrows-h'                            => 'arrows-left-right',
		'arrows-left-right'                   => 'arrows-left-right',
		'arrows-v'                            => 'arrows-up-down',
		'arrows-up-down'                      => 'arrows-up-down',
		'assistive-listening-systems'         => 'ear-listen',
		'ear-listen'                          => 'ear-listen',
		'atlas'                               => 'book-atlas',
		'book-atlas'                          => 'book-atlas',
		'atom-alt'                            => 'atom-simple',
		'atom-simple'                         => 'atom-simple',
		'backspace'                           => 'delete-left',
		'delete-left'                         => 'delete-left',
		'balance-scale'                       => 'scale-balanced',
		'scale-balanced'                      => 'scale-balanced',
		'balance-scale-left'                  => 'scale-unbalanced',
		'scale-unbalanced'                    => 'scale-unbalanced',
		'balance-scale-right'                 => 'scale-unbalanced-flip',
		'scale-unbalanced-flip'               => 'scale-unbalanced-flip',
		'band-aid'                            => 'bandage',
		'bandage'                             => 'bandage',
		'barcode-alt'                         => 'rectangle-barcode',
		'rectangle-barcode'                   => 'rectangle-barcode',
		'baseball-ball'                       => 'baseball',
		'baseball'                            => 'baseball',
		'basketball-ball'                     => 'basketball',
		'basketball'                          => 'basketball',
		'bed-alt'                             => 'bed-front',
		'bed-front'                           => 'bed-front',
		'beer'                                => 'beer-mug-empty',
		'beer-mug-empty'                      => 'beer-mug-empty',
		'betamax'                             => 'cassette-betamax',
		'cassette-betamax'                    => 'cassette-betamax',
		'bible'                               => 'book-bible',
		'book-bible'                          => 'book-bible',
		'biking'                              => 'person-biking',
		'person-biking'                       => 'person-biking',
		'biking-mountain'                     => 'person-biking-mountain',
		'person-biking-mountain'              => 'person-biking-mountain',
		'birthday-cake'                       => 'cake-candles',
		'cake-candles'                        => 'cake-candles',
		'blind'                               => 'person-walking-with-cane',
		'person-walking-with-cane'            => 'person-walking-with-cane',
		'book-alt'                            => 'book-blank',
		'book-blank'                          => 'book-blank',
		'book-dead'                           => 'book-skull',
		'book-skull'                          => 'book-skull',
		'book-reader'                         => 'book-open-reader',
		'book-open-reader'                    => 'book-open-reader',
		'book-spells'                         => 'book-sparkles',
		'book-sparkles'                       => 'book-sparkles',
		'border-style'                        => 'border-top-left',
		'border-top-left'                     => 'border-top-left',
		'border-style-alt'                    => 'border-bottom-right',
		'border-bottom-right'                 => 'border-bottom-right',
		'box-alt'                             => 'box-taped',
		'box-taped'                           => 'box-taped',
		'box-fragile'                         => 'square-fragile',
		'square-fragile'                      => 'square-fragile',
		'box-full'                            => 'box-open-full',
		'box-open-full'                       => 'box-open-full',
		'box-up'                              => 'square-this-way-up',
		'square-this-way-up'                  => 'square-this-way-up',
		'box-usd'                             => 'box-dollar',
		'box-dollar'                          => 'box-dollar',
		'boxes'                               => 'boxes-stacked',
		'boxes-stacked'                       => 'boxes-stacked',
		'boxes-alt'                           => 'boxes-stacked',
		'brackets'                            => 'brackets-square',
		'brackets-square'                     => 'brackets-square',
		'broadcast-tower'                     => 'tower-broadcast',
		'tower-broadcast'                     => 'tower-broadcast',
		'burn'                                => 'fire-flame-simple',
		'fire-flame-simple'                   => 'fire-flame-simple',
		'bus-alt'                             => 'bus-simple',
		'bus-simple'                          => 'bus-simple',
		'calculator-alt'                      => 'calculator-simple',
		'calculator-simple'                   => 'calculator-simple',
		'calendar-alt'                        => 'calendar-days',
		'calendar-days'                       => 'calendar-days',
		'calendar-edit'                       => 'calendar-pen',
		'calendar-pen'                        => 'calendar-pen',
		'calendar-times'                      => 'calendar-xmark',
		'calendar-xmark'                      => 'calendar-xmark',
		'camera-alt'                          => 'camera',
		'camera'                              => 'camera',
		'camera-home'                         => 'camera-security',
		'camera-security'                     => 'camera-security',
		'car-alt'                             => 'car-rear',
		'car-rear'                            => 'car-rear',
		'car-crash'                           => 'car-burst',
		'car-burst'                           => 'car-burst',
		'car-mechanic'                        => 'car-wrench',
		'car-wrench'                          => 'car-wrench',
		'caravan-alt'                         => 'caravan-simple',
		'caravan-simple'                      => 'caravan-simple',
		'caret-circle-down'                   => 'circle-caret-down',
		'circle-caret-down'                   => 'circle-caret-down',
		'caret-circle-left'                   => 'circle-caret-left',
		'circle-caret-left'                   => 'circle-caret-left',
		'caret-circle-right'                  => 'circle-caret-right',
		'circle-caret-right'                  => 'circle-caret-right',
		'caret-circle-up'                     => 'circle-caret-up',
		'circle-caret-up'                     => 'circle-caret-up',
		'caret-square-down'                   => 'square-caret-down',
		'square-caret-down'                   => 'square-caret-down',
		'caret-square-left'                   => 'square-caret-left',
		'square-caret-left'                   => 'square-caret-left',
		'caret-square-right'                  => 'square-caret-right',
		'square-caret-right'                  => 'square-caret-right',
		'caret-square-up'                     => 'square-caret-up',
		'square-caret-up'                     => 'square-caret-up',
		'cctv'                                => 'camera-cctv',
		'camera-cctv'                         => 'camera-cctv',
		'chalkboard-teacher'                  => 'chalkboard-user',
		'chalkboard-user'                     => 'chalkboard-user',
		'chart-pie-alt'                       => 'chart-pie-simple',
		'chart-pie-simple'                    => 'chart-pie-simple',
		'check-circle'                        => 'circle-check',
		'circle-check'                        => 'circle-check',
		'check-square'                        => 'square-check',
		'square-check'                        => 'square-check',
		'cheeseburger'                        => 'burger-cheese',
		'burger-cheese'                       => 'burger-cheese',
		'chess-bishop-alt'                    => 'chess-bishop-piece',
		'chess-bishop-piece'                  => 'chess-bishop-piece',
		'chess-clock-alt'                     => 'chess-clock-flip',
		'chess-clock-flip'                    => 'chess-clock-flip',
		'chess-king-alt'                      => 'chess-king-piece',
		'chess-king-piece'                    => 'chess-king-piece',
		'chess-knight-alt'                    => 'chess-knight-piece',
		'chess-knight-piece'                  => 'chess-knight-piece',
		'chess-pawn-alt'                      => 'chess-pawn-piece',
		'chess-pawn-piece'                    => 'chess-pawn-piece',
		'chess-queen-alt'                     => 'chess-queen-piece',
		'chess-queen-piece'                   => 'chess-queen-piece',
		'chess-rook-alt'                      => 'chess-rook-piece',
		'chess-rook-piece'                    => 'chess-rook-piece',
		'chevron-circle-down'                 => 'circle-chevron-down',
		'circle-chevron-down'                 => 'circle-chevron-down',
		'chevron-circle-left'                 => 'circle-chevron-left',
		'circle-chevron-left'                 => 'circle-chevron-left',
		'chevron-circle-right'                => 'circle-chevron-right',
		'circle-chevron-right'                => 'circle-chevron-right',
		'chevron-circle-up'                   => 'circle-chevron-up',
		'circle-chevron-up'                   => 'circle-chevron-up',
		'chevron-double-down'                 => 'chevrons-down',
		'chevrons-down'                       => 'chevrons-down',
		'chevron-double-left'                 => 'chevrons-left',
		'chevrons-left'                       => 'chevrons-left',
		'chevron-double-right'                => 'chevrons-right',
		'chevrons-right'                      => 'chevrons-right',
		'chevron-double-up'                   => 'chevrons-up',
		'chevrons-up'                         => 'chevrons-up',
		'chevron-square-down'                 => 'square-chevron-down',
		'square-chevron-down'                 => 'square-chevron-down',
		'chevron-square-left'                 => 'square-chevron-left',
		'square-chevron-left'                 => 'square-chevron-left',
		'chevron-square-right'                => 'square-chevron-right',
		'square-chevron-right'                => 'square-chevron-right',
		'chevron-square-up'                   => 'square-chevron-up',
		'square-chevron-up'                   => 'square-chevron-up',
		'clinic-medical'                      => 'house-chimney-medical',
		'house-chimney-medical'               => 'house-chimney-medical',
		'cloud-download'                      => 'cloud-arrow-down',
		'cloud-arrow-down'                    => 'cloud-arrow-down',
		'cloud-download-alt'                  => 'cloud-arrow-down',
		'cloud-upload'                        => 'cloud-arrow-up',
		'cloud-arrow-up'                      => 'cloud-arrow-up',
		'cloud-upload-alt'                    => 'cloud-arrow-up',
		'cocktail'                            => 'martini-glass-citrus',
		'martini-glass-citrus'                => 'martini-glass-citrus',
		'coffee'                              => 'mug-saucer',
		'mug-saucer'                          => 'mug-saucer',
		'coffee-togo'                         => 'cup-togo',
		'cup-togo'                            => 'cup-togo',
		'cog'                                 => 'gear',
		'gear'                                => 'gear',
		'cogs'                                => 'gears',
		'gears'                               => 'gears',
		'columns'                             => 'table-columns',
		'table-columns'                       => 'table-columns',
		'comment-alt'                         => 'message',
		'message'                             => 'message',
		'comment-alt-check'                   => 'message-check',
		'message-check'                       => 'message-check',
		'comment-alt-dollar'                  => 'message-dollar',
		'message-dollar'                      => 'message-dollar',
		'comment-alt-dots'                    => 'message-dots',
		'message-dots'                        => 'message-dots',
		'comment-alt-edit'                    => 'message-pen',
		'message-pen'                         => 'message-pen',
		'comment-alt-exclamation'             => 'message-exclamation',
		'message-exclamation'                 => 'message-exclamation',
		'comment-alt-lines'                   => 'message-lines',
		'message-lines'                       => 'message-lines',
		'comment-alt-medical'                 => 'message-medical',
		'message-medical'                     => 'message-medical',
		'comment-alt-minus'                   => 'message-minus',
		'message-minus'                       => 'message-minus',
		'comment-alt-music'                   => 'message-music',
		'message-music'                       => 'message-music',
		'comment-alt-plus'                    => 'message-plus',
		'message-plus'                        => 'message-plus',
		'comment-alt-slash'                   => 'message-slash',
		'message-slash'                       => 'message-slash',
		'comment-alt-smile'                   => 'message-smile',
		'message-smile'                       => 'message-smile',
		'comment-alt-times'                   => 'message-xmark',
		'message-xmark'                       => 'message-xmark',
		'comment-edit'                        => 'comment-pen',
		'comment-pen'                         => 'comment-pen',
		'comment-times'                       => 'comment-xmark',
		'comment-xmark'                       => 'comment-xmark',
		'comments-alt'                        => 'messages',
		'messages'                            => 'messages',
		'comments-alt-dollar'                 => 'messages-dollar',
		'messages-dollar'                     => 'messages-dollar',
		'compress-alt'                        => 'down-left-and-up-right-to-center',
		'down-left-and-up-right-to-center'    => 'down-left-and-up-right-to-center',
		'compress-arrows-alt'                 => 'minimize',
		'minimize'                            => 'minimize',
		'concierge-bell'                      => 'bell-concierge',
		'bell-concierge'                      => 'bell-concierge',
		'construction'                        => 'triangle-person-digging',
		'triangle-person-digging'             => 'triangle-person-digging',
		'conveyor-belt-alt'                   => 'conveyor-belt-boxes',
		'conveyor-belt-boxes'                 => 'conveyor-belt-boxes',
		'cowbell-more'                        => 'cowbell-circle-plus',
		'cowbell-circle-plus'                 => 'cowbell-circle-plus',
		'cricket'                             => 'cricket-bat-ball',
		'cricket-bat-ball'                    => 'cricket-bat-ball',
		'crop-alt'                            => 'crop-simple',
		'crop-simple'                         => 'crop-simple',
		'curling'                             => 'curling-stone',
		'curling-stone'                       => 'curling-stone',
		'cut'                                 => 'scissors',
		'scissors'                            => 'scissors',
		'deaf'                                => 'ear-deaf',
		'ear-deaf'                            => 'ear-deaf',
		'debug'                               => 'ban-bug',
		'ban-bug'                             => 'ban-bug',
		'desktop-alt'                         => 'desktop',
		'desktop'                             => 'desktop',
		'dewpoint'                            => 'droplet-degree',
		'droplet-degree'                      => 'droplet-degree',
		'diagnoses'                           => 'person-dots-from-line',
		'person-dots-from-line'               => 'person-dots-from-line',
		'digging'                             => 'person-digging',
		'person-digging'                      => 'person-digging',
		'digital-tachograph'                  => 'tachograph-digital',
		'tachograph-digital'                  => 'tachograph-digital',
		'directions'                          => 'diamond-turn-right',
		'diamond-turn-right'                  => 'diamond-turn-right',
		'dizzy'                               => 'face-dizzy',
		'face-dizzy'                          => 'face-dizzy',
		'dolly-flatbed'                       => 'cart-flatbed',
		'cart-flatbed'                        => 'cart-flatbed',
		'dolly-flatbed-alt'                   => 'cart-flatbed-boxes',
		'cart-flatbed-boxes'                  => 'cart-flatbed-boxes',
		'dolly-flatbed-empty'                 => 'cart-flatbed-empty',
		'cart-flatbed-empty'                  => 'cart-flatbed-empty',
		'donate'                              => 'circle-dollar-to-slot',
		'circle-dollar-to-slot'               => 'circle-dollar-to-slot',
		'dot-circle'                          => 'circle-dot',
		'circle-dot'                          => 'circle-dot',
		'drafting-compass'                    => 'compass-drafting',
		'compass-drafting'                    => 'compass-drafting',
		'drone-alt'                           => 'drone-front',
		'drone-front'                         => 'drone-front',
		'dryer-alt'                           => 'dryer-heat',
		'dryer-heat'                          => 'dryer-heat',
		'eclipse-alt'                         => 'moon-over-sun',
		'moon-over-sun'                       => 'moon-over-sun',
		'edit'                                => 'pen-to-square',
		'pen-to-square'                       => 'pen-to-square',
		'ellipsis-h'                          => 'ellipsis',
		'ellipsis'                            => 'ellipsis',
		'ellipsis-h-alt'                      => 'ellipsis-stroke',
		'ellipsis-stroke'                     => 'ellipsis-stroke',
		'ellipsis-v'                          => 'ellipsis-vertical',
		'ellipsis-vertical'                   => 'ellipsis-vertical',
		'ellipsis-v-alt'                      => 'ellipsis-stroke-vertical',
		'ellipsis-stroke-vertical'            => 'ellipsis-stroke-vertical',
		'envelope-square'                     => 'square-envelope',
		'square-envelope'                     => 'square-envelope',
		'exchange'                            => 'arrow-right-arrow-left',
		'arrow-right-arrow-left'              => 'arrow-right-arrow-left',
		'exchange-alt'                        => 'right-left',
		'right-left'                          => 'right-left',
		'exclamation-circle'                  => 'circle-exclamation',
		'circle-exclamation'                  => 'circle-exclamation',
		'exclamation-square'                  => 'square-exclamation',
		'square-exclamation'                  => 'square-exclamation',
		'exclamation-triangle'                => 'triangle-exclamation',
		'triangle-exclamation'                => 'triangle-exclamation',
		'expand-alt'                          => 'up-right-and-down-left-from-center',
		'up-right-and-down-left-from-center'  => 'up-right-and-down-left-from-center',
		'expand-arrows'                       => 'arrows-maximize',
		'arrows-maximize'                     => 'arrows-maximize',
		'expand-arrows-alt'                   => 'maximize',
		'maximize'                            => 'maximize',
		'external-link'                       => 'arrow-up-right-from-square',
		'arrow-up-right-from-square'          => 'arrow-up-right-from-square',
		'external-link-alt'                   => 'up-right-from-square',
		'up-right-from-square'                => 'up-right-from-square',
		'external-link-square'                => 'square-arrow-up-right',
		'square-arrow-up-right'               => 'square-arrow-up-right',
		'external-link-square-alt'            => 'square-up-right',
		'square-up-right'                     => 'square-up-right',
		'fast-backward'                       => 'backward-fast',
		'backward-fast'                       => 'backward-fast',
		'fast-forward'                        => 'forward-fast',
		'forward-fast'                        => 'forward-fast',
		'feather-alt'                         => 'feather-pointed',
		'feather-pointed'                     => 'feather-pointed',
		'female'                              => 'person-dress',
		'person-dress'                        => 'person-dress',
		'field-hockey'                        => 'field-hockey-stick-ball',
		'field-hockey-stick-ball'             => 'field-hockey-stick-ball',
		'fighter-jet'                         => 'jet-fighter',
		'jet-fighter'                         => 'jet-fighter',
		'file-alt'                            => 'file-lines',
		'file-lines'                          => 'file-lines',
		'file-archive'                        => 'file-zipper',
		'file-zipper'                         => 'file-zipper',
		'file-chart-line'                     => 'file-chart-column',
		'file-chart-column'                   => 'file-chart-column',
		'file-download'                       => 'file-arrow-down',
		'file-arrow-down'                     => 'file-arrow-down',
		'file-edit'                           => 'file-pen',
		'file-pen'                            => 'file-pen',
		'file-medical-alt'                    => 'file-waveform',
		'file-waveform'                       => 'file-waveform',
		'file-search'                         => 'file-magnifying-glass',
		'file-magnifying-glass'               => 'file-magnifying-glass',
		'file-times'                          => 'file-xmark',
		'file-xmark'                          => 'file-xmark',
		'file-upload'                         => 'file-arrow-up',
		'file-arrow-up'                       => 'file-arrow-up',
		'film-alt'                            => 'film-simple',
		'film-simple'                         => 'film-simple',
		'fire-alt'                            => 'fire-flame-curved',
		'fire-flame-curved'                   => 'fire-flame-curved',
		'first-aid'                           => 'kit-medical',
		'kit-medical'                         => 'kit-medical',
		'fist-raised'                         => 'hand-fist',
		'hand-fist'                           => 'hand-fist',
		'flag-alt'                            => 'flag-swallowtail',
		'flag-swallowtail'                    => 'flag-swallowtail',
		'flame'                               => 'fire-flame',
		'fire-flame'                          => 'fire-flame',
		'flask-poison'                        => 'flask-round-poison',
		'flask-round-poison'                  => 'flask-round-poison',
		'flask-potion'                        => 'flask-round-potion',
		'flask-round-potion'                  => 'flask-round-potion',
		'flushed'                             => 'face-flushed',
		'face-flushed'                        => 'face-flushed',
		'fog'                                 => 'cloud-fog',
		'cloud-fog'                           => 'cloud-fog',
		'folder-download'                     => 'folder-arrow-down',
		'folder-arrow-down'                   => 'folder-arrow-down',
		'folder-times'                        => 'folder-xmark',
		'folder-xmark'                        => 'folder-xmark',
		'folder-upload'                       => 'folder-arrow-up',
		'folder-arrow-up'                     => 'folder-arrow-up',
		'font-awesome-alt'                    => 'square-font-awesome-stroke',
		'square-font-awesome-stroke'          => 'square-font-awesome-stroke',
		'font-awesome-flag'                   => 'font-awesome',
		'font-awesome'                        => 'font-awesome',
		'font-awesome-logo-full'              => 'font-awesome',
		'football-ball'                       => 'football',
		'football'                            => 'football',
		'fragile'                             => 'wine-glass-crack',
		'wine-glass-crack'                    => 'wine-glass-crack',
		'frosty-head'                         => 'snowman-head',
		'snowman-head'                        => 'snowman-head',
		'frown'                               => 'face-frown',
		'face-frown'                          => 'face-frown',
		'frown-open'                          => 'face-frown-open',
		'face-frown-open'                     => 'face-frown-open',
		'funnel-dollar'                       => 'filter-circle-dollar',
		'filter-circle-dollar'                => 'filter-circle-dollar',
		'game-board-alt'                      => 'game-board-simple',
		'game-board-simple'                   => 'game-board-simple',
		'gamepad-alt'                         => 'gamepad-modern',
		'gamepad-modern'                      => 'gamepad-modern',
		'glass-champagne'                     => 'champagne-glass',
		'champagne-glass'                     => 'champagne-glass',
		'glass-cheers'                        => 'champagne-glasses',
		'champagne-glasses'                   => 'champagne-glasses',
		'glass-martini'                       => 'martini-glass-empty',
		'martini-glass-empty'                 => 'martini-glass-empty',
		'glass-martini-alt'                   => 'martini-glass',
		'martini-glass'                       => 'martini-glass',
		'glass-whiskey'                       => 'whiskey-glass',
		'whiskey-glass'                       => 'whiskey-glass',
		'glass-whiskey-rocks'                 => 'whiskey-glass-ice',
		'whiskey-glass-ice'                   => 'whiskey-glass-ice',
		'glasses-alt'                         => 'glasses-round',
		'glasses-round'                       => 'glasses-round',
		'globe-africa'                        => 'earth-africa',
		'earth-africa'                        => 'earth-africa',
		'globe-americas'                      => 'earth-americas',
		'earth-americas'                      => 'earth-americas',
		'globe-asia'                          => 'earth-asia',
		'earth-asia'                          => 'earth-asia',
		'globe-europe'                        => 'earth-europa',
		'earth-europa'                        => 'earth-europa',
		'golf-ball'                           => 'golf-ball-tee',
		'golf-ball-tee'                       => 'golf-ball-tee',
		'grimace'                             => 'face-grimace',
		'face-grimace'                        => 'face-grimace',
		'grin'                                => 'face-grin',
		'face-grin'                           => 'face-grin',
		'grin-alt'                            => 'face-grin-wide',
		'face-grin-wide'                      => 'face-grin-wide',
		'grin-beam'                           => 'face-grin-beam',
		'face-grin-beam'                      => 'face-grin-beam',
		'grin-beam-sweat'                     => 'face-grin-beam-sweat',
		'face-grin-beam-sweat'                => 'face-grin-beam-sweat',
		'grin-hearts'                         => 'face-grin-hearts',
		'face-grin-hearts'                    => 'face-grin-hearts',
		'grin-squint'                         => 'face-grin-squint',
		'face-grin-squint'                    => 'face-grin-squint',
		'grin-squint-tears'                   => 'face-grin-squint-tears',
		'face-grin-squint-tears'              => 'face-grin-squint-tears',
		'grin-stars'                          => 'face-grin-stars',
		'face-grin-stars'                     => 'face-grin-stars',
		'grin-tears'                          => 'face-grin-tears',
		'face-grin-tears'                     => 'face-grin-tears',
		'grin-tongue'                         => 'face-grin-tongue',
		'face-grin-tongue'                    => 'face-grin-tongue',
		'grin-tongue-squint'                  => 'face-grin-tongue-squint',
		'face-grin-tongue-squint'             => 'face-grin-tongue-squint',
		'grin-tongue-wink'                    => 'face-grin-tongue-wink',
		'face-grin-tongue-wink'               => 'face-grin-tongue-wink',
		'grin-wink'                           => 'face-grin-wink',
		'face-grin-wink'                      => 'face-grin-wink',
		'grip-horizontal'                     => 'grip',
		'grip'                                => 'grip',
		'h-square'                            => 'square-h',
		'square-h'                            => 'square-h',
		'hamburger'                           => 'burger',
		'burger'                              => 'burger',
		'hand-holding-usd'                    => 'hand-holding-dollar',
		'hand-holding-dollar'                 => 'hand-holding-dollar',
		'hand-holding-water'                  => 'hand-holding-droplet',
		'hand-holding-droplet'                => 'hand-holding-droplet',
		'hand-paper'                          => 'hand',
		'hand'                                => 'hand',
		'hand-receiving'                      => 'hands-holding-diamond',
		'hands-holding-diamond'               => 'hands-holding-diamond',
		'hand-rock'                           => 'hand-back-fist',
		'hand-back-fist'                      => 'hand-back-fist',
		'hands-heart'                         => 'hands-holding-heart',
		'hands-holding-heart'                 => 'hands-holding-heart',
		'hands-helping'                       => 'handshake-angle',
		'handshake-angle'                     => 'handshake-angle',
		'hands-usd'                           => 'hands-holding-dollar',
		'hands-holding-dollar'                => 'hands-holding-dollar',
		'hands-wash'                          => 'hands-bubbles',
		'hands-bubbles'                       => 'hands-bubbles',
		'handshake-alt'                       => 'handshake-simple',
		'handshake-simple'                    => 'handshake-simple',
		'handshake-alt-slash'                 => 'handshake-simple-slash',
		'handshake-simple-slash'              => 'handshake-simple-slash',
		'hard-hat'                            => 'helmet-safety',
		'helmet-safety'                       => 'helmet-safety',
		'hdd'                                 => 'hard-drive',
		'hard-drive'                          => 'hard-drive',
		'head-vr'                             => 'head-side-goggles',
		'head-side-goggles'                   => 'head-side-goggles',
		'headphones-alt'                      => 'headphones-simple',
		'headphones-simple'                   => 'headphones-simple',
		'heart-broken'                        => 'heart-crack',
		'heart-crack'                         => 'heart-crack',
		'heart-circle'                        => 'circle-heart',
		'circle-heart'                        => 'circle-heart',
		'heart-rate'                          => 'wave-pulse',
		'wave-pulse'                          => 'wave-pulse',
		'heart-square'                        => 'square-heart',
		'square-heart'                        => 'square-heart',
		'heartbeat'                           => 'heart-pulse',
		'heart-pulse'                         => 'heart-pulse',
		'hiking'                              => 'person-hiking',
		'person-hiking'                       => 'person-hiking',
		'history'                             => 'clock-rotate-left',
		'clock-rotate-left'                   => 'clock-rotate-left',
		'home'                                => 'house',
		'house'                               => 'house',
		'home-alt'                            => 'house',
		'home-heart'                          => 'house-heart',
		'house-heart'                         => 'house-heart',
		'home-lg'                             => 'house-chimney',
		'house-chimney'                       => 'house-chimney',
		'home-lg-alt'                         => 'house',
		'hospital-alt'                        => 'hospital',
		'hospital'                            => 'hospital',
		'hospital-symbol'                     => 'circle-h',
		'circle-h'                            => 'circle-h',
		'hot-tub'                             => 'hot-tub-person',
		'hot-tub-person'                      => 'hot-tub-person',
		'hourglass-half'                      => 'hourglass',
		'hourglass'                           => 'hourglass',
		'house-damage'                        => 'house-chimney-crack',
		'house-chimney-crack'                 => 'house-chimney-crack',
		'house-leave'                         => 'house-person-leave',
		'house-person-leave'                  => 'house-person-leave',
		'house-return'                        => 'house-person-return',
		'house-person-return'                 => 'house-person-return',
		'hryvnia'                             => 'hryvnia-sign',
		'hryvnia-sign'                        => 'hryvnia-sign',
		'humidity'                            => 'droplet-percent',
		'droplet-percent'                     => 'droplet-percent',
		'icons-alt'                           => 'symbols',
		'symbols'                             => 'symbols',
		'id-card-alt'                         => 'id-card-clip',
		'id-card-clip'                        => 'id-card-clip',
		'industry-alt'                        => 'industry-windows',
		'industry-windows'                    => 'industry-windows',
		'info-circle'                         => 'circle-info',
		'circle-info'                         => 'circle-info',
		'info-square'                         => 'square-info',
		'square-info'                         => 'square-info',
		'innosoft'                            => '42-group',
		'42-group'                            => '42-group',
		'inventory'                           => 'shelves',
		'shelves'                             => 'shelves',
		'journal-whills'                      => 'book-journal-whills',
		'book-journal-whills'                 => 'book-journal-whills',
		'kiss'                                => 'face-kiss',
		'face-kiss'                           => 'face-kiss',
		'kiss-beam'                           => 'face-kiss-beam',
		'face-kiss-beam'                      => 'face-kiss-beam',
		'kiss-wink-heart'                     => 'face-kiss-wink-heart',
		'face-kiss-wink-heart'                => 'face-kiss-wink-heart',
		'landmark-alt'                        => 'landmark-dome',
		'landmark-dome'                       => 'landmark-dome',
		'laptop-house'                        => 'house-laptop',
		'house-laptop'                        => 'house-laptop',
		'laugh'                               => 'face-laugh',
		'face-laugh'                          => 'face-laugh',
		'laugh-beam'                          => 'face-laugh-beam',
		'face-laugh-beam'                     => 'face-laugh-beam',
		'laugh-squint'                        => 'face-laugh-squint',
		'face-laugh-squint'                   => 'face-laugh-squint',
		'laugh-wink'                          => 'face-laugh-wink',
		'face-laugh-wink'                     => 'face-laugh-wink',
		'level-down'                          => 'arrow-turn-down',
		'arrow-turn-down'                     => 'arrow-turn-down',
		'level-down-alt'                      => 'turn-down',
		'turn-down'                           => 'turn-down',
		'level-up'                            => 'arrow-turn-up',
		'arrow-turn-up'                       => 'arrow-turn-up',
		'level-up-alt'                        => 'turn-up',
		'turn-up'                             => 'turn-up',
		'list-alt'                            => 'rectangle-list',
		'rectangle-list'                      => 'rectangle-list',
		'location'                            => 'location-crosshairs',
		'location-crosshairs'                 => 'location-crosshairs',
		'location-circle'                     => 'circle-location-arrow',
		'circle-location-arrow'               => 'circle-location-arrow',
		'location-slash'                      => 'location-crosshairs-slash',
		'location-crosshairs-slash'           => 'location-crosshairs-slash',
		'lock-alt'                            => 'lock-keyhole',
		'lock-keyhole'                        => 'lock-keyhole',
		'lock-open-alt'                       => 'lock-keyhole-open',
		'lock-keyhole-open'                   => 'lock-keyhole-open',
		'long-arrow-alt-down'                 => 'down-long',
		'down-long'                           => 'down-long',
		'long-arrow-alt-left'                 => 'left-long',
		'left-long'                           => 'left-long',
		'long-arrow-alt-right'                => 'right-long',
		'right-long'                          => 'right-long',
		'long-arrow-alt-up'                   => 'up-long',
		'up-long'                             => 'up-long',
		'long-arrow-down'                     => 'arrow-down-long',
		'arrow-down-long'                     => 'arrow-down-long',
		'long-arrow-left'                     => 'arrow-left-long',
		'arrow-left-long'                     => 'arrow-left-long',
		'long-arrow-right'                    => 'arrow-right-long',
		'arrow-right-long'                    => 'arrow-right-long',
		'long-arrow-up'                       => 'arrow-up-long',
		'arrow-up-long'                       => 'arrow-up-long',
		'low-vision'                          => 'eye-low-vision',
		'eye-low-vision'                      => 'eye-low-vision',
		'luchador'                            => 'luchador-mask',
		'luchador-mask'                       => 'luchador-mask',
		'luggage-cart'                        => 'cart-flatbed-suitcase',
		'cart-flatbed-suitcase'               => 'cart-flatbed-suitcase',
		'magic'                               => 'wand-magic',
		'wand-magic'                          => 'wand-magic',
		'mail-bulk'                           => 'envelopes-bulk',
		'envelopes-bulk'                      => 'envelopes-bulk',
		'male'                                => 'person',
		'person'                              => 'person',
		'map-marked'                          => 'map-location',
		'map-location'                        => 'map-location',
		'map-marked-alt'                      => 'map-location-dot',
		'map-location-dot'                    => 'map-location-dot',
		'map-marker'                          => 'location-pin',
		'location-pin'                        => 'location-pin',
		'map-marker-alt'                      => 'location-dot',
		'location-dot'                        => 'location-dot',
		'map-marker-alt-slash'                => 'location-dot-slash',
		'location-dot-slash'                  => 'location-dot-slash',
		'map-marker-check'                    => 'location-check',
		'location-check'                      => 'location-check',
		'map-marker-edit'                     => 'location-pen',
		'location-pen'                        => 'location-pen',
		'map-marker-exclamation'              => 'location-exclamation',
		'location-exclamation'                => 'location-exclamation',
		'map-marker-minus'                    => 'location-minus',
		'location-minus'                      => 'location-minus',
		'map-marker-plus'                     => 'location-plus',
		'location-plus'                       => 'location-plus',
		'map-marker-question'                 => 'location-question',
		'location-question'                   => 'location-question',
		'map-marker-slash'                    => 'location-pin-slash',
		'location-pin-slash'                  => 'location-pin-slash',
		'map-marker-smile'                    => 'location-smile',
		'location-smile'                      => 'location-smile',
		'map-marker-times'                    => 'location-xmark',
		'location-xmark'                      => 'location-xmark',
		'map-signs'                           => 'signs-post',
		'signs-post'                          => 'signs-post',
		'mars-stroke-h'                       => 'mars-stroke-right',
		'mars-stroke-right'                   => 'mars-stroke-right',
		'mars-stroke-v'                       => 'mars-stroke-up',
		'mars-stroke-up'                      => 'mars-stroke-up',
		'medium-m'                            => 'medium',
		'medium'                              => 'medium',
		'medkit'                              => 'suitcase-medical',
		'suitcase-medical'                    => 'suitcase-medical',
		'meh'                                 => 'face-meh',
		'face-meh'                            => 'face-meh',
		'meh-blank'                           => 'face-meh-blank',
		'face-meh-blank'                      => 'face-meh-blank',
		'meh-rolling-eyes'                    => 'face-rolling-eyes',
		'face-rolling-eyes'                   => 'face-rolling-eyes',
		'microphone-alt'                      => 'microphone-lines',
		'microphone-lines'                    => 'microphone-lines',
		'microphone-alt-slash'                => 'microphone-lines-slash',
		'microphone-lines-slash'              => 'microphone-lines-slash',
		'mind-share'                          => 'brain-arrow-curved-right',
		'brain-arrow-curved-right'            => 'brain-arrow-curved-right',
		'minus-circle'                        => 'circle-minus',
		'circle-minus'                        => 'circle-minus',
		'minus-hexagon'                       => 'hexagon-minus',
		'hexagon-minus'                       => 'hexagon-minus',
		'minus-octagon'                       => 'octagon-minus',
		'octagon-minus'                       => 'octagon-minus',
		'minus-square'                        => 'square-minus',
		'square-minus'                        => 'square-minus',
		'mobile-alt'                          => 'mobile-screen-button',
		'mobile-screen-button'                => 'mobile-screen-button',
		'mobile-android'                      => 'mobile',
		'mobile'                              => 'mobile',
		'mobile-android-alt'                  => 'mobile-screen',
		'mobile-screen'                       => 'mobile-screen',
		'money-bill-alt'                      => 'money-bill-1',
		'money-bill-1'                        => 'money-bill-1',
		'money-bill-wave-alt'                 => 'money-bill-1-wave',
		'money-bill-1-wave'                   => 'money-bill-1-wave',
		'money-check-alt'                     => 'money-check-dollar',
		'money-check-dollar'                  => 'money-check-dollar',
		'money-check-edit'                    => 'money-check-pen',
		'money-check-pen'                     => 'money-check-pen',
		'money-check-edit-alt'                => 'money-check-dollar-pen',
		'money-check-dollar-pen'              => 'money-check-dollar-pen',
		'monitor-heart-rate'                  => 'monitor-waveform',
		'monitor-waveform'                    => 'monitor-waveform',
		'mouse'                               => 'computer-mouse',
		'computer-mouse'                      => 'computer-mouse',
		'mouse-alt'                           => 'computer-mouse-scrollwheel',
		'computer-mouse-scrollwheel'          => 'computer-mouse-scrollwheel',
		'mouse-pointer'                       => 'arrow-pointer',
		'arrow-pointer'                       => 'arrow-pointer',
		'music-alt'                           => 'music-note',
		'music-note'                          => 'music-note',
		'music-alt-slash'                     => 'music-note-slash',
		'music-note-slash'                    => 'music-note-slash',
		'oil-temp'                            => 'oil-temperature',
		'oil-temperature'                     => 'oil-temperature',
		'page-break'                          => 'file-dashed-line',
		'file-dashed-line'                    => 'file-dashed-line',
		'paint-brush-alt'                     => 'paint-brush-fine',
		'paint-brush-fine'                    => 'paint-brush-fine',
		'pallet-alt'                          => 'pallet-boxes',
		'pallet-boxes'                        => 'pallet-boxes',
		'paragraph-rtl'                       => 'paragraph-left',
		'paragraph-left'                      => 'paragraph-left',
		'parking'                             => 'square-parking',
		'square-parking'                      => 'square-parking',
		'parking-circle'                      => 'circle-parking',
		'circle-parking'                      => 'circle-parking',
		'parking-circle-slash'                => 'ban-parking',
		'ban-parking'                         => 'ban-parking',
		'parking-slash'                       => 'square-parking-slash',
		'square-parking-slash'                => 'square-parking-slash',
		'pastafarianism'                      => 'spaghetti-monster-flying',
		'spaghetti-monster-flying'            => 'spaghetti-monster-flying',
		'pause-circle'                        => 'circle-pause',
		'circle-pause'                        => 'circle-pause',
		'paw-alt'                             => 'paw-simple',
		'paw-simple'                          => 'paw-simple',
		'pen-alt'                             => 'pen-clip',
		'pen-clip'                            => 'pen-clip',
		'pen-square'                          => 'square-pen',
		'square-pen'                          => 'square-pen',
		'pencil-alt'                          => 'pencil',
		'pencil'                              => 'pencil',
		'pencil-paintbrush'                   => 'pen-paintbrush',
		'pen-paintbrush'                      => 'pen-paintbrush',
		'pencil-ruler'                        => 'pen-ruler',
		'pen-ruler'                           => 'pen-ruler',
		'pennant'                             => 'flag-pennant',
		'flag-pennant'                        => 'flag-pennant',
		'people-arrows'                       => 'people-arrows-left-right',
		'people-arrows-left-right'            => 'people-arrows-left-right',
		'people-carry'                        => 'people-carry-box',
		'people-carry-box'                    => 'people-carry-box',
		'percentage'                          => 'percent',
		'percent'                             => 'percent',
		'person-carry'                        => 'person-carry-box',
		'person-carry-box'                    => 'person-carry-box',
		'phone-alt'                           => 'phone-flip',
		'phone-flip'                          => 'phone-flip',
		'phone-laptop'                        => 'laptop-mobile',
		'laptop-mobile'                       => 'laptop-mobile',
		'phone-square'                        => 'square-phone',
		'square-phone'                        => 'square-phone',
		'phone-square-alt'                    => 'square-phone-flip',
		'square-phone-flip'                   => 'square-phone-flip',
		'photo-video'                         => 'photo-film',
		'photo-film'                          => 'photo-film',
		'plane-alt'                           => 'plane-engines',
		'plane-engines'                       => 'plane-engines',
		'play-circle'                         => 'circle-play',
		'circle-play'                         => 'circle-play',
		'plus-circle'                         => 'circle-plus',
		'circle-plus'                         => 'circle-plus',
		'plus-hexagon'                        => 'hexagon-plus',
		'hexagon-plus'                        => 'hexagon-plus',
		'plus-octagon'                        => 'octagon-plus',
		'octagon-plus'                        => 'octagon-plus',
		'plus-square'                         => 'square-plus',
		'square-plus'                         => 'square-plus',
		'poll'                                => 'square-poll-vertical',
		'square-poll-vertical'                => 'square-poll-vertical',
		'poll-h'                              => 'square-poll-horizontal',
		'square-poll-horizontal'              => 'square-poll-horizontal',
		'portal-enter'                        => 'person-to-portal',
		'person-to-portal'                    => 'person-to-portal',
		'portal-exit'                         => 'person-from-portal',
		'person-from-portal'                  => 'person-from-portal',
		'portrait'                            => 'image-portrait',
		'image-portrait'                      => 'image-portrait',
		'pound-sign'                          => 'sterling-sign',
		'sterling-sign'                       => 'sterling-sign',
		'pray'                                => 'person-praying',
		'person-praying'                      => 'person-praying',
		'praying-hands'                       => 'hands-praying',
		'hands-praying'                       => 'hands-praying',
		'prescription-bottle-alt'             => 'prescription-bottle-medical',
		'prescription-bottle-medical'         => 'prescription-bottle-medical',
		'presentation'                        => 'presentation-screen',
		'presentation-screen'                 => 'presentation-screen',
		'print-search'                        => 'print-magnifying-glass',
		'print-magnifying-glass'              => 'print-magnifying-glass',
		'procedures'                          => 'bed-pulse',
		'bed-pulse'                           => 'bed-pulse',
		'project-diagram'                     => 'diagram-project',
		'diagram-project'                     => 'diagram-project',
		'question-circle'                     => 'circle-question',
		'circle-question'                     => 'circle-question',
		'question-square'                     => 'square-question',
		'square-question'                     => 'square-question',
		'quran'                               => 'book-quran',
		'book-quran'                          => 'book-quran',
		'rabbit-fast'                         => 'rabbit-running',
		'rabbit-running'                      => 'rabbit-running',
		'radiation-alt'                       => 'circle-radiation',
		'circle-radiation'                    => 'circle-radiation',
		'radio-alt'                           => 'radio-tuner',
		'radio-tuner'                         => 'radio-tuner',
		'random'                              => 'shuffle',
		'shuffle'                             => 'shuffle',
		'rectangle-landscape'                 => 'rectangle',
		'rectangle'                           => 'rectangle',
		'rectangle-portrait'                  => 'rectangle-vertical',
		'rectangle-vertical'                  => 'rectangle-vertical',
		'redo'                                => 'arrow-rotate-right',
		'arrow-rotate-right'                  => 'arrow-rotate-right',
		'redo-alt'                            => 'rotate-right',
		'rotate-right'                        => 'rotate-right',
		'remove-format'                       => 'text-slash',
		'text-slash'                          => 'text-slash',
		'repeat-1-alt'                        => 'arrows-repeat-1',
		'arrows-repeat-1'                     => 'arrows-repeat-1',
		'repeat-alt'                          => 'arrows-repeat',
		'arrows-repeat'                       => 'arrows-repeat',
		'retweet-alt'                         => 'arrows-retweet',
		'arrows-retweet'                      => 'arrows-retweet',
		'rss-square'                          => 'square-rss',
		'square-rss'                          => 'square-rss',
		'running'                             => 'person-running',
		'person-running'                      => 'person-running',
		'sad-cry'                             => 'face-sad-cry',
		'face-sad-cry'                        => 'face-sad-cry',
		'sad-tear'                            => 'face-sad-tear',
		'face-sad-tear'                       => 'face-sad-tear',
		'save'                                => 'floppy-disk',
		'floppy-disk'                         => 'floppy-disk',
		'sax-hot'                             => 'saxophone-fire',
		'saxophone-fire'                      => 'saxophone-fire',
		'scalpel-path'                        => 'scalpel-line-dashed',
		'scalpel-line-dashed'                 => 'scalpel-line-dashed',
		'scanner-image'                       => 'scanner',
		'scanner'                             => 'scanner',
		'search'                              => 'magnifying-glass',
		'magnifying-glass'                    => 'magnifying-glass',
		'search-dollar'                       => 'magnifying-glass-dollar',
		'magnifying-glass-dollar'             => 'magnifying-glass-dollar',
		'search-location'                     => 'magnifying-glass-location',
		'magnifying-glass-location'           => 'magnifying-glass-location',
		'search-minus'                        => 'magnifying-glass-minus',
		'magnifying-glass-minus'              => 'magnifying-glass-minus',
		'search-plus'                         => 'magnifying-glass-plus',
		'magnifying-glass-plus'               => 'magnifying-glass-plus',
		'sensor-alert'                        => 'sensor-triangle-exclamation',
		'sensor-triangle-exclamation'         => 'sensor-triangle-exclamation',
		'sensor-smoke'                        => 'sensor-cloud',
		'sensor-cloud'                        => 'sensor-cloud',
		'share-alt'                           => 'share-nodes',
		'share-nodes'                         => 'share-nodes',
		'share-alt-square'                    => 'square-share-nodes',
		'square-share-nodes'                  => 'square-share-nodes',
		'share-square'                        => 'share-from-square',
		'share-from-square'                   => 'share-from-square',
		'shield-alt'                          => 'shield-blank',
		'shield-blank'                        => 'shield-blank',
		'shipping-fast'                       => 'truck-fast',
		'truck-fast'                          => 'truck-fast',
		'shipping-timed'                      => 'truck-clock',
		'truck-clock'                         => 'truck-clock',
		'shopping-bag'                        => 'bag-shopping',
		'bag-shopping'                        => 'bag-shopping',
		'shopping-basket'                     => 'basket-shopping',
		'basket-shopping'                     => 'basket-shopping',
		'shopping-cart'                       => 'cart-shopping',
		'cart-shopping'                       => 'cart-shopping',
		'shuttle-van'                         => 'van-shuttle',
		'van-shuttle'                         => 'van-shuttle',
		'sign'                                => 'sign-hanging',
		'sign-hanging'                        => 'sign-hanging',
		'sign-in'                             => 'arrow-right-to-bracket',
		'arrow-right-to-bracket'              => 'arrow-right-to-bracket',
		'sign-in-alt'                         => 'right-to-bracket',
		'right-to-bracket'                    => 'right-to-bracket',
		'sign-language'                       => 'hands',
		'hands'                               => 'hands',
		'sign-out'                            => 'arrow-right-from-bracket',
		'arrow-right-from-bracket'            => 'arrow-right-from-bracket',
		'sign-out-alt'                        => 'right-from-bracket',
		'right-from-bracket'                  => 'right-from-bracket',
		'signal-1'                            => 'signal-weak',
		'signal-weak'                         => 'signal-weak',
		'signal-2'                            => 'signal-fair',
		'signal-fair'                         => 'signal-fair',
		'signal-3'                            => 'signal-good',
		'signal-good'                         => 'signal-good',
		'signal-4'                            => 'signal-strong',
		'signal-strong'                       => 'signal-strong',
		'signal-alt'                          => 'signal-bars',
		'signal-bars'                         => 'signal-bars',
		'signal-alt-1'                        => 'signal-bars-weak',
		'signal-bars-weak'                    => 'signal-bars-weak',
		'signal-alt-2'                        => 'signal-bars-fair',
		'signal-bars-fair'                    => 'signal-bars-fair',
		'signal-alt-3'                        => 'signal-bars-good',
		'signal-bars-good'                    => 'signal-bars-good',
		'signal-alt-slash'                    => 'signal-bars-slash',
		'signal-bars-slash'                   => 'signal-bars-slash',
		'skating'                             => 'person-skating',
		'person-skating'                      => 'person-skating',
		'ski-jump'                            => 'person-ski-jumping',
		'person-ski-jumping'                  => 'person-ski-jumping',
		'ski-lift'                            => 'person-ski-lift',
		'person-ski-lift'                     => 'person-ski-lift',
		'skiing'                              => 'person-skiing',
		'person-skiing'                       => 'person-skiing',
		'skiing-nordic'                       => 'person-skiing-nordic',
		'person-skiing-nordic'                => 'person-skiing-nordic',
		'slack-hash'                          => 'slack',
		'slack'                               => 'slack',
		'sledding'                            => 'person-sledding',
		'person-sledding'                     => 'person-sledding',
		'sliders-h'                           => 'sliders',
		'sliders'                             => 'sliders',
		'sliders-h-square'                    => 'square-sliders',
		'square-sliders'                      => 'square-sliders',
		'sliders-v'                           => 'sliders-up',
		'sliders-up'                          => 'sliders-up',
		'sliders-v-square'                    => 'square-sliders-vertical',
		'square-sliders-vertical'             => 'square-sliders-vertical',
		'smile'                               => 'face-smile',
		'face-smile'                          => 'face-smile',
		'smile-beam'                          => 'face-smile-beam',
		'face-smile-beam'                     => 'face-smile-beam',
		'smile-plus'                          => 'face-smile-plus',
		'face-smile-plus'                     => 'face-smile-plus',
		'smile-wink'                          => 'face-smile-wink',
		'face-smile-wink'                     => 'face-smile-wink',
		'smoking-ban'                         => 'ban-smoking',
		'ban-smoking'                         => 'ban-smoking',
		'sms'                                 => 'comment-sms',
		'comment-sms'                         => 'comment-sms',
		'snapchat-ghost'                      => 'snapchat',
		'snapchat'                            => 'snapchat',
		'snowboarding'                        => 'person-snowboarding',
		'person-snowboarding'                 => 'person-snowboarding',
		'snowmobile'                          => 'person-snowmobiling',
		'person-snowmobiling'                 => 'person-snowmobiling',
		'sort-alpha-down'                     => 'arrow-down-a-z',
		'arrow-down-a-z'                      => 'arrow-down-a-z',
		'sort-alpha-down-alt'                 => 'arrow-down-z-a',
		'arrow-down-z-a'                      => 'arrow-down-z-a',
		'sort-alpha-up'                       => 'arrow-up-a-z',
		'arrow-up-a-z'                        => 'arrow-up-a-z',
		'sort-alpha-up-alt'                   => 'arrow-up-z-a',
		'arrow-up-z-a'                        => 'arrow-up-z-a',
		'sort-alt'                            => 'arrow-down-arrow-up',
		'arrow-down-arrow-up'                 => 'arrow-down-arrow-up',
		'sort-amount-down'                    => 'arrow-down-wide-short',
		'arrow-down-wide-short'               => 'arrow-down-wide-short',
		'sort-amount-down-alt'                => 'arrow-down-short-wide',
		'arrow-down-short-wide'               => 'arrow-down-short-wide',
		'sort-amount-up'                      => 'arrow-up-wide-short',
		'arrow-up-wide-short'                 => 'arrow-up-wide-short',
		'sort-amount-up-alt'                  => 'arrow-up-short-wide',
		'arrow-up-short-wide'                 => 'arrow-up-short-wide',
		'sort-circle'                         => 'circle-sort',
		'circle-sort'                         => 'circle-sort',
		'sort-circle-down'                    => 'circle-sort-down',
		'circle-sort-down'                    => 'circle-sort-down',
		'sort-circle-up'                      => 'circle-sort-up',
		'circle-sort-up'                      => 'circle-sort-up',
		'sort-numeric-down'                   => 'arrow-down-1-9',
		'arrow-down-1-9'                      => 'arrow-down-1-9',
		'sort-numeric-down-alt'               => 'arrow-down-9-1',
		'arrow-down-9-1'                      => 'arrow-down-9-1',
		'sort-numeric-up'                     => 'arrow-up-1-9',
		'arrow-up-1-9'                        => 'arrow-up-1-9',
		'sort-numeric-up-alt'                 => 'arrow-up-9-1',
		'arrow-up-9-1'                        => 'arrow-up-9-1',
		'sort-shapes-down'                    => 'arrow-down-triangle-square',
		'arrow-down-triangle-square'          => 'arrow-down-triangle-square',
		'sort-shapes-down-alt'                => 'arrow-down-square-triangle',
		'arrow-down-square-triangle'          => 'arrow-down-square-triangle',
		'sort-shapes-up'                      => 'arrow-up-triangle-square',
		'arrow-up-triangle-square'            => 'arrow-up-triangle-square',
		'sort-shapes-up-alt'                  => 'arrow-up-square-triangle',
		'arrow-up-square-triangle'            => 'arrow-up-square-triangle',
		'sort-size-down'                      => 'arrow-down-big-small',
		'arrow-down-big-small'                => 'arrow-down-big-small',
		'sort-size-down-alt'                  => 'arrow-down-small-big',
		'arrow-down-small-big'                => 'arrow-down-small-big',
		'sort-size-up'                        => 'arrow-up-big-small',
		'arrow-up-big-small'                  => 'arrow-up-big-small',
		'sort-size-up-alt'                    => 'arrow-up-small-big',
		'arrow-up-small-big'                  => 'arrow-up-small-big',
		'soup'                                => 'bowl-hot',
		'bowl-hot'                            => 'bowl-hot',
		'space-shuttle'                       => 'shuttle-space',
		'shuttle-space'                       => 'shuttle-space',
		'space-station-moon-alt'              => 'space-station-moon-construction',
		'space-station-moon-construction'     => 'space-station-moon-construction',
		'square-root-alt'                     => 'square-root-variable',
		'square-root-variable'                => 'square-root-variable',
		'star-half-alt'                       => 'star-half-stroke',
		'star-half-stroke'                    => 'star-half-stroke',
		'starfighter-alt'                     => 'starfighter-twin-ion-engine',
		'starfighter-twin-ion-engine'         => 'starfighter-twin-ion-engine',
		'step-backward'                       => 'backward-step',
		'backward-step'                       => 'backward-step',
		'step-forward'                        => 'forward-step',
		'forward-step'                        => 'forward-step',
		'sticky-note'                         => 'note-sticky',
		'note-sticky'                         => 'note-sticky',
		'stop-circle'                         => 'circle-stop',
		'circle-stop'                         => 'circle-stop',
		'store-alt'                           => 'shop',
		'shop'                                => 'shop',
		'store-alt-slash'                     => 'shop-slash',
		'shop-slash'                          => 'shop-slash',
		'stream'                              => 'bars-staggered',
		'bars-staggered'                      => 'bars-staggered',
		'subway'                              => 'train-subway',
		'train-subway'                        => 'train-subway',
		'surprise'                            => 'face-surprise',
		'face-surprise'                       => 'face-surprise',
		'swimmer'                             => 'person-swimming',
		'person-swimming'                     => 'person-swimming',
		'swimming-pool'                       => 'water-ladder',
		'water-ladder'                        => 'water-ladder',
		'sync'                                => 'arrows-rotate',
		'arrows-rotate'                       => 'arrows-rotate',
		'sync-alt'                            => 'rotate',
		'rotate'                              => 'rotate',
		'table-tennis'                        => 'table-tennis-paddle-ball',
		'table-tennis-paddle-ball'            => 'table-tennis-paddle-ball',
		'tablet-alt'                          => 'tablet-screen-button',
		'tablet-screen-button'                => 'tablet-screen-button',
		'tablet-android'                      => 'tablet',
		'tablet'                              => 'tablet',
		'tablet-android-alt'                  => 'tablet-screen',
		'tablet-screen'                       => 'tablet-screen',
		'tachometer'                          => 'gauge-simple',
		'gauge-simple'                        => 'gauge-simple',
		'tachometer-alt'                      => 'gauge',
		'gauge'                               => 'gauge',
		'tachometer-alt-average'              => 'gauge-med',
		'gauge-med'                           => 'gauge-med',
		'tachometer-alt-fast'                 => 'gauge',
		'tachometer-alt-fastest'              => 'gauge-max',
		'gauge-max'                           => 'gauge-max',
		'tachometer-alt-slow'                 => 'gauge-low',
		'gauge-low'                           => 'gauge-low',
		'tachometer-alt-slowest'              => 'gauge-min',
		'gauge-min'                           => 'gauge-min',
		'tachometer-average'                  => 'gauge-simple-med',
		'gauge-simple-med'                    => 'gauge-simple-med',
		'tachometer-fast'                     => 'gauge-simple',
		'tachometer-fastest'                  => 'gauge-simple-max',
		'gauge-simple-max'                    => 'gauge-simple-max',
		'tachometer-slow'                     => 'gauge-simple-low',
		'gauge-simple-low'                    => 'gauge-simple-low',
		'tachometer-slowest'                  => 'gauge-simple-min',
		'gauge-simple-min'                    => 'gauge-simple-min',
		'tanakh'                              => 'book-tanakh',
		'book-tanakh'                         => 'book-tanakh',
		'tasks'                               => 'list-check',
		'list-check'                          => 'list-check',
		'tasks-alt'                           => 'bars-progress',
		'bars-progress'                       => 'bars-progress',
		'telegram-plane'                      => 'telegram',
		'telegram'                            => 'telegram',
		'temperature-down'                    => 'temperature-arrow-down',
		'temperature-arrow-down'              => 'temperature-arrow-down',
		'temperature-frigid'                  => 'temperature-snow',
		'temperature-snow'                    => 'temperature-snow',
		'temperature-hot'                     => 'temperature-sun',
		'temperature-sun'                     => 'temperature-sun',
		'temperature-up'                      => 'temperature-arrow-up',
		'temperature-arrow-up'                => 'temperature-arrow-up',
		'tenge'                               => 'tenge-sign',
		'tenge-sign'                          => 'tenge-sign',
		'th'                                  => 'table-cells',
		'table-cells'                         => 'table-cells',
		'th-large'                            => 'table-cells-large',
		'table-cells-large'                   => 'table-cells-large',
		'th-list'                             => 'table-list',
		'table-list'                          => 'table-list',
		'theater-masks'                       => 'masks-theater',
		'masks-theater'                       => 'masks-theater',
		'thermometer-empty'                   => 'temperature-empty',
		'temperature-empty'                   => 'temperature-empty',
		'thermometer-full'                    => 'temperature-full',
		'temperature-full'                    => 'temperature-full',
		'thermometer-half'                    => 'temperature-half',
		'temperature-half'                    => 'temperature-half',
		'thermometer-quarter'                 => 'temperature-quarter',
		'temperature-quarter'                 => 'temperature-quarter',
		'thermometer-three-quarters'          => 'temperature-three-quarters',
		'temperature-three-quarters'          => 'temperature-three-quarters',
		'thunderstorm'                        => 'cloud-bolt',
		'cloud-bolt'                          => 'cloud-bolt',
		'thunderstorm-moon'                   => 'cloud-bolt-moon',
		'cloud-bolt-moon'                     => 'cloud-bolt-moon',
		'thunderstorm-sun'                    => 'cloud-bolt-sun',
		'cloud-bolt-sun'                      => 'cloud-bolt-sun',
		'ticket-alt'                          => 'ticket-simple',
		'ticket-simple'                       => 'ticket-simple',
		'times'                               => 'xmark',
		'xmark'                               => 'xmark',
		'times-circle'                        => 'circle-xmark',
		'circle-xmark'                        => 'circle-xmark',
		'times-hexagon'                       => 'hexagon-xmark',
		'hexagon-xmark'                       => 'hexagon-xmark',
		'times-octagon'                       => 'octagon-xmark',
		'octagon-xmark'                       => 'octagon-xmark',
		'times-square'                        => 'square-xmark',
		'square-xmark'                        => 'square-xmark',
		'tint'                                => 'droplet',
		'droplet'                             => 'droplet',
		'tint-slash'                          => 'droplet-slash',
		'droplet-slash'                       => 'droplet-slash',
		'tired'                               => 'face-tired',
		'face-tired'                          => 'face-tired',
		'toilet-paper-alt'                    => 'toilet-paper-blank',
		'toilet-paper-blank'                  => 'toilet-paper-blank',
		'tombstone-alt'                       => 'tombstone-blank',
		'tombstone-blank'                     => 'tombstone-blank',
		'tools'                               => 'screwdriver-wrench',
		'screwdriver-wrench'                  => 'screwdriver-wrench',
		'torah'                               => 'scroll-torah',
		'scroll-torah'                        => 'scroll-torah',
		'tram'                                => 'train-tram',
		'train-tram'                          => 'train-tram',
		'transgender-alt'                     => 'transgender',
		'transgender'                         => 'transgender',
		'trash-alt'                           => 'trash-can',
		'trash-can'                           => 'trash-can',
		'trash-restore'                       => 'trash-arrow-up',
		'trash-arrow-up'                      => 'trash-arrow-up',
		'trash-restore-alt'                   => 'trash-can-arrow-up',
		'trash-can-arrow-up'                  => 'trash-can-arrow-up',
		'trash-undo-alt'                      => 'trash-can-undo',
		'trash-can-undo'                      => 'trash-can-undo',
		'tree-alt'                            => 'tree-deciduous',
		'tree-deciduous'                      => 'tree-deciduous',
		'triangle-music'                      => 'triangle-instrument',
		'triangle-instrument'                 => 'triangle-instrument',
		'trophy-alt'                          => 'trophy-star',
		'trophy-star'                         => 'trophy-star',
		'truck-couch'                         => 'truck-ramp-couch',
		'truck-ramp-couch'                    => 'truck-ramp-couch',
		'truck-loading'                       => 'truck-ramp-box',
		'truck-ramp-box'                      => 'truck-ramp-box',
		'tshirt'                              => 'shirt',
		'shirt'                               => 'shirt',
		'tv-alt'                              => 'tv',
		'tv'                                  => 'tv',
		'undo'                                => 'arrow-rotate-left',
		'arrow-rotate-left'                   => 'arrow-rotate-left',
		'undo-alt'                            => 'rotate-left',
		'rotate-left'                         => 'rotate-left',
		'university'                          => 'building-columns',
		'building-columns'                    => 'building-columns',
		'unlink'                              => 'link-slash',
		'link-slash'                          => 'link-slash',
		'unlock-alt'                          => 'unlock-keyhole',
		'unlock-keyhole'                      => 'unlock-keyhole',
		'usd-circle'                          => 'circle-dollar',
		'circle-dollar'                       => 'circle-dollar',
		'usd-square'                          => 'square-dollar',
		'square-dollar'                       => 'square-dollar',
		'user-alt'                            => 'user-large',
		'user-large'                          => 'user-large',
		'user-alt-slash'                      => 'user-large-slash',
		'user-large-slash'                    => 'user-large-slash',
		'user-chart'                          => 'chart-user',
		'chart-user'                          => 'chart-user',
		'user-circle'                         => 'circle-user',
		'circle-user'                         => 'circle-user',
		'user-cog'                            => 'user-gear',
		'user-gear'                           => 'user-gear',
		'user-edit'                           => 'user-pen',
		'user-pen'                            => 'user-pen',
		'user-friends'                        => 'user-group',
		'user-group'                          => 'user-group',
		'user-hard-hat'                       => 'user-helmet-safety',
		'user-helmet-safety'                  => 'user-helmet-safety',
		'user-md'                             => 'user-doctor',
		'user-doctor'                         => 'user-doctor',
		'user-md-chat'                        => 'user-doctor-message',
		'user-doctor-message'                 => 'user-doctor-message',
		'user-times'                          => 'user-xmark',
		'user-xmark'                          => 'user-xmark',
		'users-class'                         => 'screen-users',
		'screen-users'                        => 'screen-users',
		'users-cog'                           => 'users-gear',
		'users-gear'                          => 'users-gear',
		'users-crown'                         => 'user-group-crown',
		'user-group-crown'                    => 'user-group-crown',
		'utensil-fork'                        => 'fork',
		'fork'                                => 'fork',
		'utensil-knife'                       => 'knife',
		'knife'                               => 'knife',
		'utensil-spoon'                       => 'spoon',
		'spoon'                               => 'spoon',
		'utensils-alt'                        => 'fork-knife',
		'fork-knife'                          => 'fork-knife',
		'vhs'                                 => 'cassette-vhs',
		'cassette-vhs'                        => 'cassette-vhs',
		'volleyball-ball'                     => 'volleyball',
		'volleyball'                          => 'volleyball',
		'volume-down'                         => 'volume-low',
		'volume-low'                          => 'volume-low',
		'volume-mute'                         => 'volume-xmark',
		'volume-xmark'                        => 'volume-xmark',
		'volume-up'                           => 'volume-high',
		'volume-high'                         => 'volume-high',
		'vote-nay'                            => 'xmark-to-slot',
		'xmark-to-slot'                       => 'xmark-to-slot',
		'vote-yea'                            => 'check-to-slot',
		'check-to-slot'                       => 'check-to-slot',
		'walking'                             => 'person-walking',
		'person-walking'                      => 'person-walking',
		'warehouse-alt'                       => 'warehouse-full',
		'warehouse-full'                      => 'warehouse-full',
		'washer'                              => 'washing-machine',
		'washing-machine'                     => 'washing-machine',
		'water-lower'                         => 'water-arrow-down',
		'water-arrow-down'                    => 'water-arrow-down',
		'water-rise'                          => 'water-arrow-up',
		'water-arrow-up'                      => 'water-arrow-up',
		'waveform-path'                       => 'waveform-lines',
		'waveform-lines'                      => 'waveform-lines',
		'webcam'                              => 'camera-web',
		'camera-web'                          => 'camera-web',
		'webcam-slash'                        => 'camera-web-slash',
		'camera-web-slash'                    => 'camera-web-slash',
		'weight'                              => 'weight-scale',
		'weight-scale'                        => 'weight-scale',
		'wifi-1'                              => 'wifi-weak',
		'wifi-weak'                           => 'wifi-weak',
		'wifi-2'                              => 'wifi-fair',
		'wifi-fair'                           => 'wifi-fair',
		'window-alt'                          => 'window-flip',
		'window-flip'                         => 'window-flip',
		'window-close'                        => 'rectangle-xmark',
		'rectangle-xmark'                     => 'rectangle-xmark',
		'wine-glass-alt'                      => 'wine-glass-empty',
		'wine-glass-empty'                    => 'wine-glass-empty',
	);

	return $font_awesome_5_polyfiller;
}
