<?php

namespace WebpConverter\Conversion\Directory;

/**
 * Supports data about /uploads-webpc directory.
 */
class UploadsWebpcDirectory extends DirectoryAbstract {

	const DIRECTORY_NAME = 'uploads-webpc';
	const DIRECTORY_TYPE = 'webp';
	const DIRECTORY_PATH = '%s/uploads-webpc';

	/**
	 * {@inheritdoc}
	 */
	public function get_type(): string {
		return self::DIRECTORY_TYPE;
	}

	/**
	 * {@inheritdoc}
	 */
	public function is_available(): bool {
		return true;
	}

	/**
	 * {@inheritdoc}
	 */
	public function is_output_directory(): bool {
		return true;
	}

	/**
	 * {@inheritdoc}
	 */
	public function get_relative_path(): string {
		if ( defined( 'UPLOADS' ) ) {
			$uploads_dir = trim( UPLOADS, '/\\' );
			return trim( sprintf( self::DIRECTORY_PATH, dirname( $uploads_dir ) ), '/\\.' );
		}

		return sprintf( self::DIRECTORY_PATH, basename( WP_CONTENT_DIR ) );
	}
}
